﻿/*		VERSION:	1.0
	WHAT THIS IS:
		A container to put LoopSet's into.
		It contains a loop that powers all the other loop-sets.
		It also contains legacy functions.
	
	HELPER FUNCTIONS:
		clear()																		Remove all LoopSets.
	
	LEGACY FUNCTIONS:
		addObject( myObject, setName )						Adds an object to a LoopSet.  (and creates a new LoopSet if neccessary)
		removeObject( myObject, setName )					Removes an object from a LoopSet.
		removeSet( setName )											Removes a LoopSet.
		pauseSet( setName, pauseValue )						Pause/resume all objects in a LoopSet.
		pauseObject( myObject, pauseValue )				Pause/resume an object.
*/

import program.*;
#include "nextDepth.as"
makeLoopManager = function( parent_mc, instanceName, depth )
{
	// resolve optional parameters
	var parent_mc = parent_mc || this;
	var instanceName = instanceName || "";
	var depth = (depth!=undefined) ? depth : nextDepth(parent_mc);
	var _this = parent_mc.createEmptyMovieClip( instanceName, depth );
	
	// container
	var _this = this.createEmptyMovieClip("loop_mc", 0);
	
	// main loop
	_this.onEnterFrame = function(){
		trace("");
		_this.resetLoops();
		// call the LoopSets in forward order by using a reversed list  (for...in always loops backwards)
		var reverseList = {};
		for(var nam in _this)
			if(_this[nam].pause_obj.isPaused==false)
				reverseList[nam] = null;
		
		for(var nam in reverseList){
			_this[nam].loop();
			_this[nam].pause_obj.hasLooped = true;
		}
	}// main loop()
	
	// reset objects for the next loop
	_this.resetLoops = function(){
		for(var nam in _this){
			if(_this[nam].pause_obj.hasLooped == true){
				_this[nam].pause_obj.hasLooped = false;		// allow this LoopSet itself to be run
				_this[nam].resetLoops();									// tell this LoopSet to allow its children to be run
			}// if:  not already reset  (prevent infinite recusion)
		}// for:  each loop-set within this container
	}// resetAllLoops()
	
	
	
	_this.clear = function(){																		//Remove all LoopSets.
		for(var nam in _this)					// check everything in this container
			if(_this[nam].pause_obj)		// if this item is pausable
				delete _this[nam];				// remove it
	}// clear()
	
	
	
	// ________________________________________________________________________________________________
	// LEGACY FUNCTIONS  (not required)
	_this.addObject = function( myObject, setName )						//Adds an object to a LoopSet.  (and creates a new LoopSet if neccessary)
	{
		if(!_this[setName])
			_this[setName] = new program.LoopSet();
		_this[setName].addObject( myObject )
	}// addObject()
	
	
	_this.removeObject = function( myObject, setName ){					//Removes an object from a LoopSet.
		_this[setName].removeObject( myObject );
	}// removeObject()
	
	
	_this.removeSet = function( setName ){											//Removes a LoopSet.
		delete _this[setName];
	}// removeSet()
	
	
	_this.pauseSet = function( setName, pauseValue ){						//Pause/resume all objects in a LoopSet.
		if(!_this[setName].pause_obj.freeze)
			_this[setName].pause_obj.isPaused = pauseValue;
	}// pauseSet()
	
	
	_this.pauseObject = function( obj_ref, newValue ){					//Pause/resume an object.
//		if(!obj_ref.pause_obj.freeze)
//			obj_ref.pause_obj.isPaused = newValue;
		program.LoopSet.pauseObject( obj_ref, newValue );
	}// pauseObject()
	
	_this.freezeObject = function( obj_ref, newFreeze){
		//obj_ref.pause_obj.freeze = newFreeze || true;
		program.LoopSet.freezeObject( obj_ref, newFreeze );
	}// freezeObject()
	
	
	
	// ________________________________________________________________________________________________
	return _this;
}// makeLoopManager()